# Weekly Planning Workflow

Run this every Monday morning to set up your week.

## Overview

| Step | Time | Output |
|------|------|--------|
| 1. Review last week | 10 min | Wins and learnings |
| 2. Check goals | 5 min | Goal alignment |
| 3. Identify priorities | 10 min | Top 3 for the week |
| 4. Block time | 10 min | Calendar updated |
| 5. Share plan | 5 min | Team visibility |

**Total:** ~40 minutes

---

## Step 1: Review Last Week

**Look at:**
- What shipped?
- What slipped? Why?
- What did I learn?
- What feedback did I get?

**Prompt:**
```
Review my meetings and tasks from last week. What were the key outcomes and any items that carried over?
```

---

## Step 2: Check Goals

**Reference:** `context/goals.md`

Ask:
- Are we on track for Q1 goals?
- Any goal at risk?
- What moved the needle last week?

**Prompt:**
```
Compare my progress against @goals.md. What's on track, at risk, or blocked?
```

---

## Step 3: Identify Priorities

Pick your **Top 3** for the week:
1. Most important outcome
2. Second most important
3. Third priority

**Rules:**
- Only 3 - if everything is priority, nothing is
- Outcomes, not tasks ("Ship X" not "Work on X")
- Aligned to goals

**Prompt:**
```
Based on my goals and current projects, what should my top 3 priorities be this week?
```

---

## Step 4: Block Time

For each priority:
- Block focus time on calendar
- Identify meetings that support it
- Decline/move meetings that don't

**Protect:**
- 2+ hours of focus time daily
- Prep time before key meetings
- Buffer between meetings

---

## Step 5: Share Plan

Post to team channel:

```
My week:
1. [Priority 1]
2. [Priority 2]
3. [Priority 3]

Key meetings: [list]
Blocked on: [if any]
```

**Prompt:**
```
/weekly-update with my top 3 priorities for this week
```

---

## Artifacts

- `tasks.md` updated with this week's items
- Calendar blocked appropriately
- Team notified of priorities
