# Sprint Review Workflow

Run this at the end of each sprint (usually bi-weekly).

## Overview

| Step | Time | Output |
|------|------|--------|
| 1. Gather outcomes | 15 min | What shipped |
| 2. Analyze metrics | 10 min | Impact assessment |
| 3. Collect feedback | 10 min | Team input |
| 4. Document learnings | 10 min | Retro notes |
| 5. Plan next sprint | 15 min | Priorities set |

**Total:** ~60 minutes

---

## Step 1: Gather Outcomes

**What shipped this sprint?**

For each item:
- Feature/fix name
- Who worked on it
- Current status (shipped, in review, rolled back)

**Prompt:**
```
List what shipped in the last 2 weeks based on my meeting notes and project files.
```

---

## Step 2: Analyze Metrics

**Questions to answer:**
- Did we hit our sprint goals?
- What's the user impact?
- Any unexpected outcomes?

**Check:**
- Usage metrics for new features
- Bug counts / support tickets
- Performance metrics

---

## Step 3: Collect Feedback

**From engineering:**
- What went well technically?
- What was harder than expected?
- Technical debt created/addressed?

**From design:**
- Design feedback from users?
- Any patterns to update?

**From stakeholders:**
- Customer feedback?
- Sales/support insights?

---

## Step 4: Document Learnings

**What did we learn?**

Format:
- **What worked:** [Keep doing]
- **What didn't:** [Stop or change]
- **What to try:** [Experiments for next sprint]

**Prompt:**
```
Based on this sprint's outcomes and feedback, what are the key learnings? Format as worked/didn't work/try next.
```

---

## Step 5: Plan Next Sprint

**Inputs:**
- Backlog priorities
- Carryover from this sprint
- New requests/feedback
- Goal alignment

**Output:**
- Sprint goal (one sentence)
- Committed items
- Stretch items

**Prompt:**
```
Based on @backlog.md and @goals.md, what should we prioritize for next sprint?
```

---

## Artifacts

- Sprint review doc (share with team)
- Updated `backlog.md`
- Next sprint plan
- `tasks.md` refreshed
