# Research Synthesis Workflow

How to turn messy research into actionable insights.

## Overview

| Phase | Time | Output |
|-------|------|--------|
| 1. Gather sources | 15 min | File list |
| 2. Extract insights | 30-60 min | Raw themes |
| 3. Synthesize patterns | 30 min | Key findings |
| 4. Prioritize | 15 min | Ranked insights |
| 5. Share | 15 min | Synthesis doc |

**Total:** ~2 hours

---

## Phase 1: Gather Sources

**Collect all relevant research:**
- Interview transcripts
- Survey results
- Support tickets
- Usage data
- Competitor analysis
- Market research

**Organize:**
- Put files in `projects/[project]/research/`
- Name consistently: `interview-[role]-[name].md`

---

## Phase 2: Extract Insights

**For each source, identify:**
- Pain points mentioned
- Goals/jobs to be done
- Current workarounds
- Feature requests
- Emotional moments (frustration, delight)
- Surprising quotes

**Prompt:**
```
Read @research/[file] and extract: pain points, goals, workarounds, requests, and key quotes. Format as bullet points.
```

**Or batch process:**
```
/synthesize-research projects/[project]/research/
```

---

## Phase 3: Synthesize Patterns

**Look for:**
- **Frequency:** What comes up most often?
- **Severity:** What's most painful?
- **Segments:** Do different users say different things?
- **Contradictions:** Where do users disagree?

**Create themes:**
- Group similar insights
- Name each theme
- Count how many sources mention it

**Prompt:**
```
Group these insights into themes. For each theme: name it, summarize it, list which sources support it, and include the best quote.
```

---

## Phase 4: Prioritize

**Rank themes by:**
1. Frequency (how many mentioned it)
2. Severity (how painful)
3. Opportunity (can we solve it)
4. Alignment (does it fit our strategy)

**Identify:**
- Top 3 insights (act on these)
- Interesting but secondary (monitor)
- Outliers worth noting (investigate)

**Prompt:**
```
Prioritize these themes by frequency, severity, and opportunity. What are the top 3 we should act on?
```

---

## Phase 5: Share

**Synthesis doc structure:**

1. **Executive Summary** (3-5 bullets)
2. **Methodology** (what we did)
3. **Key Findings** (top themes)
4. **Supporting Evidence** (quotes, data)
5. **Recommendations** (what to do)
6. **Appendix** (raw data links)

**Prompt:**
```
Format this synthesis using @one-pager.md template. Make it shareable with stakeholders.
```

**Save as:** `projects/[project]/user-research-synthesis.md`

---

## Tips

- **Quantity matters:** 5+ interviews to see patterns
- **Verbatim quotes:** More compelling than summaries
- **Stay neutral:** Report what you heard, not what you wanted to hear
- **Segment if needed:** Different users may have different needs
- **Update regularly:** Research goes stale

---

## Artifacts

- Organized research files
- Synthesis document
- Stakeholder presentation (if needed)
