# PRD Creation Workflow

How to create a Product Requirements Document from scratch.

## Overview

| Phase | Time | Output |
|-------|------|--------|
| 1. Define the problem | 30 min | Problem statement |
| 2. Gather context | 1-2 hrs | Research synthesis |
| 3. Draft requirements | 1-2 hrs | PRD v1 |
| 4. Review & refine | 1 hr | PRD v2 |
| 5. Get alignment | 30 min | Approved PRD |

**Total:** ~4-6 hours

---

## Phase 1: Define the Problem

Before writing anything, answer:

1. **What problem are we solving?**
   - Who has this problem?
   - How painful is it? (frequency, severity)
   - What do they do today?

2. **Why solve it now?**
   - Goal alignment
   - Customer demand
   - Competitive pressure
   - Opportunity cost of waiting

3. **What does success look like?**
   - User outcome
   - Business metric
   - How we'll measure

**Prompt:**
```
Help me define the problem for [feature]. I need: problem statement, who it affects, current workarounds, and why now.
```

---

## Phase 2: Gather Context

**Research to collect:**
- User research / interviews
- Usage data
- Support tickets
- Competitor analysis
- Technical constraints

**Prompt:**
```
/synthesize-research [folder] - What are the key insights relevant to [problem]?
```

**Prompt:**
```
Based on @user-research-synthesis.md and @goals.md, what context should inform requirements for [feature]?
```

---

## Phase 3: Draft Requirements

**PRD structure:**

1. **Overview**
   - Problem statement
   - Success metrics
   - Scope (what's in/out)

2. **User Stories**
   - As a [user], I want [goal] so that [benefit]
   - Acceptance criteria for each

3. **Requirements**
   - Functional requirements
   - Non-functional (performance, security)
   - Edge cases

4. **Design**
   - Key flows
   - Wireframes/mocks (link)
   - Open design questions

5. **Technical Considerations**
   - Known constraints
   - Dependencies
   - Questions for engineering

6. **Launch Plan**
   - Rollout strategy
   - Success criteria
   - Rollback plan

**Prompt:**
```
Create a PRD for [feature] based on this context: [paste or reference files]. Use @one-pager.md as the format foundation but expand for a full PRD.
```

---

## Phase 4: Review & Refine

**Self-review:**
- Is the problem clear?
- Are requirements testable?
- What's missing?

**Stakeholder review:**

**Prompt:**
```
/prd-review requirements.md
```

This gets feedback from:
- Engineering (feasibility, edge cases)
- Executive (alignment, ROI)
- Design (UX, flows)

**Incorporate feedback and update.**

---

## Phase 5: Get Alignment

**Alignment meeting:**
- Walk through PRD
- Address open questions
- Get explicit sign-off

**Attendees:**
- Engineering lead
- Design lead
- Your manager (if significant)

**After approval:**
- Move to project folder
- Create tickets/tasks
- Kick off design/eng work

---

## Artifacts

- PRD document in `projects/[project]/requirements.md`
- Research synthesis
- Stakeholder sign-off (in meeting notes)
