# Launch Checklist Workflow

Everything needed to ship a feature successfully.

---

## Pre-Launch (1-2 weeks before)

### Product
- [ ] PRD approved and shared
- [ ] Success metrics defined
- [ ] Rollout plan documented
- [ ] Rollback plan ready

### Engineering
- [ ] Code complete and reviewed
- [ ] Tests passing
- [ ] Performance validated
- [ ] Security review (if needed)
- [ ] Feature flags configured

### Design
- [ ] Final designs approved
- [ ] Edge cases covered
- [ ] Accessibility checked
- [ ] Mobile/responsive verified

### QA
- [ ] Test plan executed
- [ ] Regression testing done
- [ ] Bug bar met
- [ ] Sign-off received

---

## Launch Prep (3-5 days before)

### Documentation
- [ ] Help docs written/updated
- [ ] Internal wiki updated
- [ ] Release notes drafted
- [ ] Known issues documented

### Communication
- [ ] Customer success briefed
- [ ] Support team trained
- [ ] Sales team informed
- [ ] Internal announcement drafted

### Monitoring
- [ ] Dashboards ready
- [ ] Alerts configured
- [ ] On-call schedule confirmed
- [ ] Escalation path clear

---

## Launch Day

### Go/No-Go
- [ ] Final stakeholder check-in
- [ ] All checklist items complete
- [ ] Team available for support
- [ ] Decision: GO / NO-GO

### Release
- [ ] Feature flag enabled (staged rollout)
- [ ] Monitoring dashboards open
- [ ] Team on standby
- [ ] Initial metrics check

### Communication
- [ ] Internal announcement sent
- [ ] Customer communication (if applicable)
- [ ] Social/blog post (if applicable)

---

## Post-Launch (1-3 days after)

### Monitoring
- [ ] Metrics tracking (hourly → daily)
- [ ] Error rates normal
- [ ] Performance stable
- [ ] No critical bugs

### Feedback
- [ ] Support ticket review
- [ ] User feedback collected
- [ ] Team retro scheduled

### Rollout
- [ ] Expand to next cohort
- [ ] Continue until 100%
- [ ] Or rollback if needed

---

## Post-Launch (1-2 weeks after)

### Analysis
- [ ] Success metrics evaluated
- [ ] User feedback synthesized
- [ ] Learnings documented

### Follow-up
- [ ] Fast-follows identified
- [ ] Bugs prioritized
- [ ] Backlog updated

### Celebration
- [ ] Team recognized
- [ ] Wins shared
- [ ] Retro completed

---

## Rollback Triggers

**Rollback immediately if:**
- Error rate > [X]%
- P0 bug affecting > [X] users
- Data integrity issue
- Security vulnerability

**Rollback process:**
1. Disable feature flag
2. Notify team
3. Communicate to affected users
4. Investigate root cause
5. Fix and re-test before retry

---

## Prompt

```
Create a launch checklist for [feature] based on this template. Customize for our specific needs and timeline.
```
