# Tools

Utility scripts and resources for common PM tasks.

## Scripts

| Script | Purpose | Usage |
|--------|---------|-------|
| `youtube-transcript.py` | Get transcript from YouTube video | `python youtube-transcript.py <url>` |
| `csv-to-markdown.py` | Convert CSV to markdown table | `python csv-to-markdown.py <file.csv>` |
| `screenshot-ocr.py` | Extract text from screenshot | `python screenshot-ocr.py <image>` |

## Setup

Most scripts need Python 3.8+ and some dependencies:

```bash
pip install youtube-transcript-api pytesseract pillow
```

For OCR, you'll also need Tesseract installed:
- Mac: `brew install tesseract`
- Ubuntu: `apt-get install tesseract-ocr`

## MCP Integrations

Claude Code can connect to external tools via MCP. Some useful ones for PMs:

- **Google Drive** - Access docs, sheets, slides
- **Notion** - Read/write Notion pages
- **Linear** - Manage issues and projects
- **Slack** - Search messages, post updates

Setup instructions: [Claude Code MCP Docs](https://docs.anthropic.com/claude-code/mcp)

## Adding Your Own

Drop scripts here and Claude can run them for you:

```
> Run the youtube transcript script on this video: [url]
```

Keep scripts simple and single-purpose.
