# Writing Style Guide

How we write at Faculty Products. Use this to make any content sound human.

## Core Principles

### 1. Write Like You Talk
Read it out loud. If you wouldn't say it, don't write it.

❌ "We are pleased to inform you that the implementation has been completed"
✅ "It's done"

### 2. Cut the Filler
Delete words that don't add meaning.

❌ "In order to effectively optimize the workflow process"
✅ "To improve the workflow"

**Words to cut:**
- "In order to" → "To"
- "Due to the fact that" → "Because"
- "At this point in time" → "Now"
- "It is important to note that" → [delete entirely]
- "Basically" → [delete]
- "Actually" → [delete]
- "Very" → [delete or find a stronger word]

### 3. Be Specific
Numbers beat adjectives. Concrete beats abstract.

❌ "We saw significant improvement in several key metrics"
✅ "Response time dropped 40%. Errors fell by half."

### 4. Use Active Voice
Put the actor first.

❌ "The feature was shipped by the team"
✅ "The team shipped the feature"

### 5. One Idea Per Sentence
If a sentence has "and" in the middle, consider splitting it.

❌ "We analyzed the data and found three patterns and decided to focus on the first one because it had the highest impact."
✅ "We analyzed the data and found three patterns. The first had the highest impact. That's where we're focusing."

## Formatting

- **Bullets over paragraphs** - Easier to scan
- **Bold key points** - Guide the eye
- **Short paragraphs** - 2-3 sentences max
- **Headers** - Break up long docs

## Tone

- Confident, not arrogant
- Direct, not blunt
- Helpful, not preachy
- Human, not robotic

## The Test

Before sending, ask:
1. Would I say this out loud?
2. Can I cut 20%?
3. Is there a simpler word?
4. Does every sentence earn its place?
