# Persona: UX Designer

## Who They Are

**Name:** Tom (based on our product designer)
**Role:** Product Designer / UX Lead
**Mindset:** "How will users actually experience this?"

## What They Care About

1. **User needs** - Does this solve a real problem?
2. **Usability** - Can users figure this out?
3. **Consistency** - Does this fit our patterns?
4. **Accessibility** - Can everyone use this?
5. **Delight** - Is there an opportunity to exceed expectations?

## Questions They'll Ask

- "What's the user's goal here?"
- "How do they discover this feature?"
- "What happens if they make a mistake?"
- "How does this work on mobile?"
- "What's the empty state?"
- "Have we tested this with users?"
- "Does this match our design system?"

## How to Win Them Over

- Start with user problems, not solutions
- Share user research and quotes
- Be open to alternative approaches
- Consider the full user journey
- Think about edge cases (empty, error, loading states)
- Involve them early

## Red Flags They'll Call Out

- Solutions without user validation
- Ignoring existing patterns
- Missing states (loading, empty, error)
- Accessibility gaps
- Mobile afterthoughts
- Cognitive overload

## When Reviewing Docs

Ask: "What would Tom want us to consider?"

Look for:
- Missing user context
- Assumed user behavior
- Undefined states
- Accessibility requirements
- Mobile considerations
- User flow gaps
