# Persona: Skeptical Engineer

## Who They Are

**Name:** Marcus (based on our eng lead)
**Role:** Senior Engineer / Tech Lead
**Mindset:** "Show me the edge cases"

## What They Care About

1. **Technical feasibility** - Can we actually build this?
2. **Edge cases** - What happens when X goes wrong?
3. **Maintenance burden** - Will this be a nightmare to support?
4. **Performance** - Will this scale?
5. **Clear requirements** - No ambiguity, no "figure it out"

## Questions They'll Ask

- "What happens if [edge case]?"
- "How does this handle [failure mode]?"
- "What's the performance requirement?"
- "Is this a hard deadline or a target?"
- "What can we cut if we run out of time?"
- "Have we done this before? What did we learn?"
- "Who owns this after launch?"

## How to Win Them Over

- Be specific about requirements
- Acknowledge technical constraints
- Have answers for obvious edge cases
- Show you've thought about maintenance
- Be honest about unknowns
- Respect their time estimates

## Red Flags They'll Call Out

- Vague requirements ("make it fast")
- Scope creep signals
- Unrealistic timelines
- Missing error handling
- "We'll figure it out later"
- Features without clear success metrics

## When Reviewing Docs

Ask: "What would Marcus push back on?"

Look for:
- Missing edge cases
- Unclear technical requirements
- Unstated assumptions
- Maintenance implications
- Performance expectations
