# User Research Synthesis: TA Workload & Grading

## Executive Summary

We interviewed 12 users (4 professors, 8 TAs) about their experience with grading workflows and TA management. Three clear themes emerged:

1. **Grading inconsistency is the #1 pain point** - TAs interpret rubrics differently, causing unfair grade distributions
2. **Workload visibility is near zero** - Professors can't see who's overloaded until deadlines are missed
3. **Calibration happens too late** - By the time inconsistency is caught, damage is done

## Methodology

- 12 semi-structured interviews (45-60 min each)
- Mix of professors (4) and TAs (8)
- Conducted January 2026
- Focused on grading workflows and team coordination

## Key Findings

### Theme 1: Grading Inconsistency

**Frequency:** 10 of 12 mentioned this
**Severity:** High - directly impacts student outcomes

TAs apply rubrics differently, leading to unfair grade distributions within the same class.

**Key quotes:**
> "I've had students complain that their friend got a better grade for basically the same answer. They were graded by different TAs." - Prof. Martinez

> "We don't really talk about grading standards until someone complains. By then it's too late." - TA Sarah

> "I grade harder than most TAs. I know this. But no one's ever told me to change." - TA Marcus

**Root causes:**
- Rubrics are ambiguous
- No calibration before grading starts
- No feedback loop during grading
- TAs work in isolation

### Theme 2: Workload Invisibility

**Frequency:** 8 of 12 mentioned this
**Severity:** High - leads to burnout and delays

Professors have no way to see workload distribution until problems surface.

**Key quotes:**
> "I didn't know James was drowning until he missed the grading deadline. I could have helped if I'd known earlier." - Prof. Chen

> "Some weeks I grade 50 papers, some weeks it's 150. There's no way for Professor Williams to know that." - TA Emily

> "I just wish there was a dashboard or something. I'm flying blind." - Prof. Okonkwo

**Root causes:**
- No real-time workload visibility
- Assignment distribution happens once, never revisited
- TAs don't want to "complain" about workload
- Time tracking is manual and unreliable

### Theme 3: Reactive Calibration

**Frequency:** 6 of 12 mentioned this
**Severity:** Medium - could be prevented

Calibration sessions happen after problems are discovered, not before.

**Key quotes:**
> "We do a calibration session at the start of the semester, but by week 4 everyone's drifted." - Prof. Williams

> "I'd love to see how my grades compare to other TAs in real-time. Just a sanity check." - TA Priya

**Root causes:**
- Calibration is a one-time event
- No ongoing feedback
- Grade comparison feels taboo

## Insights by User Type

### Professors
- Want visibility without micromanaging
- Need proactive alerts, not reactive firefighting
- Value fairness across student experience

### TAs
- Want to do a good job but lack guidance
- Don't know how their work compares to peers
- Hesitant to raise workload concerns

## Recommendations

1. **Build workload dashboard** - Real-time visibility into grading distribution
2. **Add consistency scoring** - Show deviation from rubric average per TA
3. **Create proactive alerts** - Notify professors before problems escalate
4. **Enable peer comparison** - Let TAs see how they compare (opt-in)

## Appendix: Interview Sources

| ID | Role | Context |
|----|------|---------|
| Prof. Martinez | Professor | Intro Psych, 280 students, 6 TAs |
| Prof. Chen | Professor | Organic Chemistry, 180 students, 4 TAs |
| Prof. Okonkwo | Professor | African Literature, 90 students, 2 TAs |
| Prof. Williams | Professor | Statistics, 320 students, 8 TAs |
| TA Sarah | TA | 2nd year, Intro Psych |
| TA James | TA | 1st year, Organic Chemistry |
| TA Priya | TA | 3rd year, Statistics |
| TA Marcus | TA | 2nd year, Statistics |
| TA Emily | TA | 1st year, African Literature |
| TA Carlos | TA | 2nd year, Intro Psych |
| TA Aisha | TA | 3rd year, Organic Chemistry |
| TA David | TA | 1st year, Statistics |

Full transcripts in `research/` folder.
