# TA Workload Tracker - Requirements

## TL;DR

Build a dashboard that shows professors how grading work is distributed across their TAs, flags inconsistencies, and helps rebalance workload before problems escalate.

## Problem Statement

Professors managing TA teams have no visibility into workload distribution until it's too late. TAs burn out, grading quality suffers, and students get inconsistent experiences.

**Evidence:**
- 8 of 12 interviewed TAs mentioned workload imbalance as a top frustration
- Professors report discovering overloaded TAs only after missed deadlines
- Grading consistency varies by 0.8 points on average across TAs

## Success Metrics

| Metric | Current | Target |
|--------|---------|--------|
| Professors who can identify overloaded TAs in 1 click | 12% | 90% |
| Time to detect workload imbalance | 2+ weeks | < 24 hours |
| TA-reported workload satisfaction | 3.2/5 | 4.0/5 |

## User Stories

### Professor View

**As a professor, I want to see grading distribution across my TAs so I can identify imbalances early.**
- Dashboard shows assignments graded per TA
- Time spent grading per TA
- Comparison to expected workload

**As a professor, I want to be alerted when a TA is overloaded so I can intervene.**
- Alert when TA exceeds 120% of average workload
- Alert when TA is falling behind on grading queue
- Weekly summary email of workload status

**As a professor, I want to see grading consistency scores so I can identify calibration needs.**
- Deviation from rubric average per TA
- Grade distribution comparison
- Flag outlier grades

### TA View

**As a TA, I want to see my workload compared to peers so I know if I'm on track.**
- My grading count vs team average
- My queue vs team queue
- Estimated time to complete

## Requirements

### Functional

1. **Workload Dashboard**
   - Display grading count per TA (daily, weekly, all-time)
   - Show time-tracking estimates
   - Visualize distribution (bar chart)
   - Compare to expected/assigned workload

2. **Alerts System**
   - Configurable threshold (default: 120%)
   - In-app notification
   - Email digest option
   - One-click to reassign

3. **Consistency Scores**
   - Calculate deviation from rubric mean
   - Show grade distribution per TA
   - Flag grades outside 2 standard deviations
   - Link to calibration tools

4. **Rebalancing**
   - Suggest reassignments based on queue
   - One-click reassign
   - History of reassignments

### Non-Functional

- Page load < 2 seconds
- Real-time updates (< 5 min delay)
- Mobile-responsive
- Accessible (WCAG 2.1 AA)

## Out of Scope (v1)

- Automated reassignment (requires manual approval)
- TA performance reviews
- Integration with external tools
- Historical trend analysis (future release)

## Design

See Figma: [link]

Key screens:
1. Overview dashboard
2. Individual TA detail
3. Alert configuration
4. Reassignment flow

## Technical Considerations

- Build on existing grading data pipeline
- Need new consistency calculation service
- Consider caching for performance
- Feature flag for rollout

## Open Questions

1. Should TAs see each other's workload?
2. What's the right threshold for alerts?
3. How do we handle TAs who are intentionally assigned more?

## Launch Plan

1. Beta with 5 professors (week 9)
2. Iterate on feedback (week 9-10)
3. GA launch (week 10)
4. Monitor metrics for 2 weeks

## Appendix

See `user-research-synthesis.md` for full research findings.
