# GradeFlow - Product Overview

## What It Is

GradeFlow is a course management platform that helps professors manage grading, TAs, and student progress - designed around how educators actually work.

## Core Users

### Primary: Professors
- Manage courses, assignments, grading
- Coordinate TA teams
- Track student progress
- Pain: Too much time on admin, not enough on teaching

### Secondary: Teaching Assistants
- Grade assignments
- Hold office hours
- Support students
- Pain: Inconsistent guidance, invisible workload

### Tertiary: Students
- Submit work, view feedback
- Track progress
- Pain: Slow feedback, unclear expectations

## Key Features

### Grading
- Rubric-based grading with AI suggestions
- Batch grading workflows
- Inline annotation and feedback
- Grade distribution analytics

### TA Management
- Assignment distribution
- Grading calibration tools
- Workload visibility
- Performance tracking

### Course Management
- Syllabus and schedule
- Assignment creation
- Student roster
- Progress dashboards

### Feedback
- Rich text and audio feedback
- Feedback templates
- Reusable comments library
- Student-facing feedback portal

## Architecture

- Web app (React + Node)
- Mobile apps (React Native)
- API-first design
- Integrations: Canvas, Blackboard, Google Classroom

## Metrics That Matter

| Metric | Current | Target |
|--------|---------|--------|
| Professor WAU | 1,800 | 2,500 |
| TA adoption | 62% | 80% |
| Grading time saved | 4.2 hrs/week | 6 hrs/week |
| NPS | 42 | 50 |

## Pricing

- **Starter:** Free for courses < 50 students
- **Pro:** $8/student/semester
- **Enterprise:** Custom (university-wide deals)

## Roadmap Themes

1. **TA Excellence** (Q1 2026) - Current focus
2. **AI Feedback** (Q2 2026)
3. **Analytics & Insights** (Q3 2026)
4. **Integrations Expansion** (Q4 2026)
