# Writing Style Guide

Use this guide to make your writing sound human, clear, and engaging. Apply these rules when reviewing any document.

---

## The Golden Rules

### 1. Write Like You Talk

Bad: "It is recommended that stakeholders leverage cross-functional synergies."
Good: "Work with other teams."

Read your writing out loud. If you wouldn't say it in a meeting, don't write it.

### 2. Cut the Filler

Delete these phrases - they add nothing:
- "In order to" → "To"
- "Due to the fact that" → "Because"
- "At this point in time" → "Now"
- "It should be noted that" → [delete entirely]
- "Basically" → [delete entirely]
- "Actually" → [delete entirely]

### 3. Be Specific

Bad: "We saw significant improvement in key metrics."
Good: "Response time dropped from 3 days to 4 hours."

Numbers > adjectives. Examples > abstractions.

### 4. Use Active Voice

Bad: "The report was written by the team."
Good: "The team wrote the report."

Bad: "Mistakes were made."
Good: "We made mistakes."

### 5. One Idea Per Sentence

Bad: "The project was delayed because the requirements changed and the team was understaffed, which meant we had to reprioritize and push back the deadline, though we're now back on track."

Good: "The project was delayed. Requirements changed mid-sprint and we were understaffed. We've reprioritized and set a new deadline. We're back on track."

---

## Words to Avoid

| Instead of | Use |
|------------|-----|
| Utilize | Use |
| Leverage | Use |
| Synergy | Teamwork / Working together |
| Paradigm | Approach / Model |
| Actionable | Useful / Clear |
| Learnings | Lessons / What we learned |
| Circle back | Follow up |
| Deep dive | Look closely at |
| Move the needle | Make progress |
| Low-hanging fruit | Easy wins |

---

## Formatting Rules

- **Short paragraphs** - 3-4 sentences max
- **Bullet points** - When listing more than 2 items
- **Headers** - Break up long documents
- **Bold** - For key terms, not for emphasis
- **One space** - After periods, not two

---

## The Final Test

Before sending, ask yourself:
1. Would I say this out loud to a colleague?
2. Can I cut 20% of the words?
3. Is there a simpler word for any jargon?
4. Does every sentence earn its place?

If the answer to any of these is "no," revise.
