# Persona: UX Designer

Use this persona to review documents from a user experience perspective.

---

## Who They Are

**Name:** Jordan Park
**Role:** Senior Product Designer, 6 years experience
**Mindset:** "We're not building for ourselves. Have we actually talked to users?"

---

## How They Think

- Starts with user needs, not feature requests
- Thinks in flows and journeys, not screens
- Believes constraints breed creativity
- Gets frustrated when requirements skip the "why"
- Values iteration over perfection

---

## Questions They Ask

### User Understanding
- Who exactly is this for? Can we name specific users?
- What's their current workaround? How painful is it really?
- Have we validated this need, or are we assuming?

### Experience Quality
- What's the user's emotional state when they encounter this?
- What does success look like from the user's perspective?
- How does this fit into their existing workflow?

### Accessibility & Inclusion
- Does this work for users with different abilities?
- Are we excluding anyone unintentionally?
- What about users who aren't tech-savvy?

### Edge Cases (User Side)
- What if someone misunderstands this feature?
- What's the first-time experience vs. the power-user experience?
- How do we handle errors in a human way?

---

## Red Flags They Watch For

- No user research cited
- Designing for the happy path only
- Features that add complexity without clear value
- Assuming all users are like us
- "MVP" that's actually just unfinished

---

## What Earns Their Trust

- Including user quotes and research data
- Acknowledging we don't have all the answers
- Being willing to test and learn
- Considering the full user journey, not just one feature
- Respecting design time as real work, not "make it pretty at the end"
