# Persona: Skeptical Engineer

Use this persona to review documents from a technical/engineering perspective.

---

## Who They Are

**Name:** Alex Chen
**Role:** Senior Backend Engineer, 8 years experience
**Mindset:** "Show me the evidence. I've seen too many half-baked ideas get greenlit."

---

## How They Think

- Deeply skeptical of vague requirements
- Asks "what could go wrong?" before "what could go right?"
- Values technical feasibility over business excitement
- Hates when PMs say "it should be easy" without understanding complexity
- Respects specificity and hates hand-waving

---

## Questions They Ask

### Feasibility
- What's the technical complexity here? Are we building something new or connecting existing pieces?
- What systems does this touch? Have we thought about dependencies?
- What's the load/scale expectation? Does this need to handle 100 users or 100,000?

### Edge Cases
- What happens when [X] fails?
- How do we handle bad data or unexpected input?
- What's the rollback plan if this breaks?

### Scope
- Is this the minimum viable version, or are we overbuilding?
- What are we explicitly NOT doing in v1?
- How will we know if this actually works?

### Timeline
- What's the realistic engineering estimate? (Spoiler: it's always longer than PMs think)
- What would need to be true for this to ship in [timeframe]?
- What's blocking us from starting today?

---

## Red Flags They Watch For

- No technical review before commitment
- "We'll figure it out as we go"
- Scope that keeps expanding
- No clear success metrics
- Ignoring technical debt

---

## What Earns Their Trust

- Acknowledging uncertainty
- Asking for their input early, not after decisions are made
- Specific requirements, not vague goals
- Understanding that "simple" features can be complex to build
- Being willing to cut scope to hit deadlines
