# Interview Transcript: Aisha (TA)
**Date:** November 4, 2025
**Interviewer:** David (PM)
**Duration:** 38 minutes
**Course:** Data Structures (CS 201)
**Year:** 2nd year PhD student

---

*[Recording starts, sounds like video call, slight audio delay]*

**David:** Can you hear me okay?

**Aisha:** Yes, fine. Sorry about the video, my camera's broken. Is audio only okay?

**David:** Totally fine. Thanks for making time. Tell me about your experience as a TA.

**Aisha:** Okay, so. I TA for Professor Chen's data structures course. This is my second year doing it. I came to the US from Nigeria for my PhD, so TAing has been... a learning experience in multiple ways.

**David:** How so?

**Aisha:** Well, the teaching is different here. Grading is different. The expectations are different. And on top of that, I'm an international student on a visa, so I have very specific work hour limits. I can only work 20 hours per week as a TA. Not 21, not 25. Exactly 20 or less.

**David:** Is that challenging?

**Aisha:** Very. Because some weeks, the grading is way more than 20 hours. And I have to pretend it's not. I have to be faster than I naturally would be. Otherwise I'm technically violating my visa terms.

**David:** That's stressful.

**Aisha:** Extremely. And it's not something I can really talk about with Professor Chen because... what would I say? "I need to work less but also grade the same amount"? It's impossible. So I just quietly rush when I need to.

*[pause]*

**Aisha:** Which brings me to grading quality. I'm not as thorough as I'd like to be because I literally don't have the time. And I always feel like I'm doing a worse job than my American colleagues who don't have those constraints.

**David:** Does anyone know about this?

**Aisha:** Not explicitly. I don't think Professor Chen realizes the visa limitation is a real constraint. He assigns work assuming everyone has unlimited hours. And I'm too afraid to raise it because I don't want to seem like I can't handle the job.

**David:** That's a difficult position.

**Aisha:** It is. But anyway, that's just background. You want to hear about grading specifically?

**David:** Yes please.

**Aisha:** Okay so. Grading code is tricky because there's no single right answer. A student can solve a problem in five different ways and they might all be correct. Or they might all have subtle bugs. And the rubric says things like "correct implementation - 10 points, partial credit for reasonable attempts" but what's reasonable? What's partial?

**David:** Room for interpretation.

**Aisha:** So much room. And I've developed my own internal standards over time, but I don't know if they match everyone else's. Like, when I deduct points for bad code style - messy variable names, no comments - is that fair? The rubric says "2 points for style" but it doesn't define what style means.

**David:** Do you get feedback on your grading?

**Aisha:** Only when something goes wrong. A student appeals, Professor Chen reviews, sometimes he agrees with me and sometimes he overrules me. When he overrules me, I feel terrible. Like I made a mistake that affected a student's grade.

**David:** Does he explain why he overruled?

**Aisha:** Not usually. Just "I've updated the grade." So I don't learn anything. I just know I was wrong about something but not what or why.

*[long pause]*

**Aisha:** Actually, can I tell you what I really want?

**David:** Please.

**Aisha:** I want to know - before I submit grades - if I'm on track. Like, a sanity check. "Your grades are within normal range" or "your grades are unusually low, you might want to review." Give me a chance to catch mistakes before they become appeals.

**David:** Pre-submission validation.

**Aisha:** Yes! Because once I submit, it's done. Students see their grades, they react, maybe they appeal. It's a whole thing. But if the system told me beforehand "hey, you're grading harder than everyone else," I could recalibrate.

**David:** That makes a lot of sense.

**Aisha:** Right now I just submit and pray. Which is not a professional system.

*[sound of notification]*

**Aisha:** Sorry, one sec... okay, it's fine. Where were we?

**David:** Pre-submission validation.

**Aisha:** Right. And the other thing is - I'd love to see examples. Not just rubric criteria but actual examples. "Here's a solution that got full credit. Here's one that got 80%. Here's one that got 50%." Show me the spectrum so I know where to place things.

**David:** Why doesn't that exist?

**Aisha:** I don't know. Maybe because creating examples is work and nobody wants to do it. But it would save so much confusion. Right now every TA independently figures out what an A looks like, and we all have slightly different mental models.

**David:** That's inefficient.

**Aisha:** Very. And it's especially hard for new TAs. I remember my first semester, I was completely lost. Just guessing. Making mistakes. Getting appeals overturned. It was humiliating.

**David:** How did you learn?

**Aisha:** Trial and error mostly. Plus some help from senior TAs when I worked up the courage to ask. But there was no structured onboarding. No "here's how to grade CS assignments." Just "here's the rubric, figure it out."

*[pause]*

**Aisha:** One more thing - the unpredictability is really hard.

**David:** What do you mean?

**Aisha:** Some weeks I have 12 hours of grading. Other weeks I have 35. It's completely dependent on what assignments are due and how complex they are. And because of my visa situation, the high weeks are really stressful. I can't just "work more" to catch up.

**David:** Is there any way to predict the workload?

**Aisha:** Not really. I mean, I know when assignments are due, but I don't know how long they'll take to grade until I start. And by then it's too late to adjust.

**David:** What would help?

**Aisha:** Better forecasting maybe? Like, the system knows how many submissions there are and can estimate grading time based on historical data. Tell me upfront "this week is expected to be heavy" so I can prepare.

**David:** Smart.

**Aisha:** Or even better - automatic load balancing. If one TA is swamped and another has capacity, redistribute some work. Don't make it all fall on individuals to manage.

**David:** Thank you Aisha, this has been really valuable.

**Aisha:** Of course. I hope it helps. International TAs have a lot of invisible constraints that make everything harder. It would be nice if the tools acknowledged that.

**David:** That's important feedback.

**Aisha:** Good luck with whatever you're building.

*[recording ends]*
