# Faculty Products - Company Overview

ok so this is everything I've been able to gather about the company. some of this is from the wiki, some from Rebecca's all-hands slides, some from random slack threads. sorry it's kind of a mess - David said to just dump everything in here and we'd organize it later. lol "later"

## The Basics

Faculty Products - founded 2019, Seattle-based. Dr. Rebecca Liu (CEO, former Stanford prof) and Marcus Thompson (CTO, ex-Google PM) started it. The story goes that Rebecca was spending like 20+ hours a week just on grading and TA management and was like "this is insane, there has to be a better way." Marcus was her neighbor apparently? They started building GradeFlow in Rebecca's garage. Classic startup origin story.

Now we're ~45 people. Most in Seattle but we have folks in Boston, Austin, Toronto working remote. Product team is 8 people I think - 2 PMs (David is the lead, the other PM role is what I'm filling), 4 designers, 2 researchers. Engineering is like 22 people. Then customer success (8), sales (4), and ops (3).

## What We Actually Do

GradeFlow is the product. Course management platform for universities. We're in 200+ universities across North America now.

The pitch is basically: professors spend 15+ hours/week on BS administrative stuff instead of teaching:
- Grading and writing feedback
- Managing TAs (assigning work, checking their grading, dealing with inconsistencies)
- Tracking which students are struggling
- Coordinating all the logistics
- Answering the same questions over and over

And academic software historically sucks. Built by people who've never taught. Rebecca always says "we build for how professors actually work, not how IT departments think they should work"

### The Product Modules (from the marketing site)

**Assignment Hub** - create and distribute assignments, handles all file types (code, essays, problem sets, multimedia), plagiarism detection, flexible due dates

**Grading Center** - rubric-based grading, annotation tools, batch grading, analytics on grade distribution

**TA Management** - this is supposedly our differentiator. Assign TAs to sections or assignment types, track their progress, calibration exercises (though I've heard these don't work that well in practice??), office hours scheduling

**Student Portal** - students see their grades, submit work, message TAs/profs

**Analytics Dashboard** - class trends, early warning for struggling students, time tracking, semester comparisons

### Integrations

We plug into Canvas, Blackboard, Moodle (the big LMS players). Also GitHub/GitLab for CS courses. Slack and Teams for comms. Google Cal and Outlook. Student info systems like Banner and PeopleSoft.

This is actually a big deal for sales - universities won't buy anything that doesn't integrate with their existing stack.

## Who Uses This Thing

**Primary users: Professors**
- Tenure-track faculty at research universities (this is like our core)
- Lecturers and adjuncts
- Department chairs

**Secondary: TAs**
- Grad student TAs (biggest group)
- Undergrad course assistants
- Lab instructors

This is where it gets interesting - I keep hearing that professors love us but TAs are kind of meh. The TA tools feel like an afterthought? Something to dig into.

**Tertiary: Students**
- Just use it to submit and see feedback
- Not really who we design for

## Competition

From Rebecca's board deck:

- **Gradescope** (owned by Turnitin now) - really good for STEM, especially auto-grading code and math. Weak in humanities. "They're our main competitor in CS departments"
- **Canvas SpeedGrader** - built into Canvas so it's "free" but super limited
- **Crowdmark** - expensive, aimed at huge courses (think 1000+ students)
- **Homegrown stuff** - lots of departments just build their own janky tools in Google Sheets

How we're supposedly different:
1. Professor-first design - "built by educators for educators"
2. Actually care about TAs - competitors ignore them
3. Works for small seminars AND huge lectures
4. Better analytics

idk how much of this is marketing vs reality. need to dig in.

## Company Values (from the wiki)

**Empathy First** - "We build for real people with real constraints. Every feature starts with professor and TA interviews."

**Simplicity Over Features** - "We'd rather do 10 things excellently than 50 things adequately."

**Academic Integrity** - "We're building for education, not surveillance." (this comes up a lot - there's been internal debates about adding more monitoring features and Rebecca keeps shooting them down)

**Sustainable Pace** - "Higher ed moves slowly. We build for the long term."

## Recent History / Milestones

(copied from the Q4 all-hands slides)

- Q3 2024: Launched AI-assisted feedback suggestions (still in beta, mixed reception)
- Q2 2024: Hit 200 university customers!!
- Q1 2024: Series B closed - $28M
- Q4 2023: Mobile apps launched (iOS/Android)
- Q2 2023: Canvas integration (huge for sales)

## The Problems / Challenges

This is from David's notes - these are the things the product team is supposed to be focused on:

1. **Scaling support** - we grew fast and customer success is struggling to keep the same level of service. Response times are up, CSAT is down a bit.

2. **TA adoption is... not great** - Professors are happy (NPS is high) but TAs are lukewarm. They use it because they have to, not because they love it. This feels like a big opportunity but also kind of embarrassing that our "TA-first" differentiator isn't landing with actual TAs.

3. **Grading consistency is the #1 complaint** - Even with calibration tools, TA grading is all over the place. Professor Martinez (one of our biggest champions!) literally said "GradeFlow doesn't solve my real problem." That hurts.

4. **Enterprise sales is hard** - We're good at selling to individual departments but full-university deals require different conversations (IT, procurement, legal, accessibility). Marcus is hiring a VP of Sales to figure this out.

## What's Next / Roadmap Themes

From the product strategy doc:

**Theme 1: AI-powered assistance**
Help profs and TAs work faster without losing quality. The beta AI feedback tool is a start but needs work.

**Theme 2: Better TA tools**
Make TAs first-class users. This is where I think there's a lot of opportunity - the TA experience feels bolted on.

**Theme 3: Cross-course insights**
Help departments see patterns across ALL their courses, not just individual classes. This is more of an admin/chair feature.

## Random Stuff I've Picked Up

From slack/conversations/etc:

- Rebecca does office hours every Friday where anyone can ask her anything. Apparently very useful for understanding priorities.

- The research team just finished a big study on grading consistency. Should get access to that.

- There's tension between "move fast" (we're a startup) and "sustainable pace" (our stated value). Some people feel like we're shipping too fast and quality is slipping.

- The AI feedback beta has been controversial. Some professors love it, others think it's going to make TAs lazy or produce generic feedback.

- Mobile apps aren't used that much. Most grading happens on desktop.

- There's a Slack channel called #ta-advocacy that some people started. Might be good to look at.

- Marcus (CTO) is apparently really data-driven. If you want to propose something, come with numbers.

- David (my boss) has been here since the beginning. Really knows the product and customers. Super responsive on Slack.

## Questions I Still Have

- What exactly is "calibration" and why isn't it working?
- How do TAs actually feel about the product? The data seems mixed.
- What happened with the AI feedback beta? What did we learn?
- Who are our power users and what do they do differently?
- What's the deal with the enterprise sales motion?

---

*This doc is a mess, I know. Will clean up once I have a better handle on things.*

*Questions? I'm on slack - should probably figure out who else to talk to*

*Last updated: January 2026*
