# GradeFlow Brand Guidelines
*Draft v2.3 - Last updated November 2025*
*Contact: marketing@facultyproducts.com*

---

## Brand Overview

GradeFlow is the flagship product of Faculty Products, a Seattle-based edtech company founded in 2019. Our mission is to give educators time back by eliminating the busywork that pulls them away from teaching.

### Brand Promise
"We build for how professors actually work, not how IT departments think they should work."

### Brand Personality
- **Empathetic** - We deeply understand the challenges of teaching
- **Practical** - We focus on real solutions, not buzzwords
- **Trustworthy** - Educators rely on us for their most important work
- **Approachable** - Complex problems don't require complex interfaces

---

## Visual Identity

### Primary Colors

| Color | Hex | RGB | Usage |
|-------|-----|-----|-------|
| GradeFlow Blue | #2563EB | rgb(37, 99, 235) | Primary actions, headers, links |
| Academic Navy | #1E3A5F | rgb(30, 58, 95) | Text, navigation, formal contexts |
| Success Green | #059669 | rgb(5, 150, 105) | Confirmations, completed states |
| Warning Amber | #D97706 | rgb(217, 119, 6) | Alerts, deadlines, attention |
| Error Red | #DC2626 | rgb(220, 38, 38) | Errors, critical alerts |

### Secondary Colors

| Color | Hex | RGB | Usage |
|-------|-----|-----|-------|
| Soft Gray | #F3F4F6 | rgb(243, 244, 246) | Backgrounds, cards |
| Medium Gray | #9CA3AF | rgb(156, 163, 175) | Secondary text, borders |
| Light Blue | #DBEAFE | rgb(219, 234, 254) | Highlights, selected states |

### Typography

**Primary Typeface:** Inter
- Use for all UI elements, body text, and general communications
- Weights: Regular (400), Medium (500), Semibold (600), Bold (700)

**Secondary Typeface:** Source Serif Pro
- Use for marketing headlines, formal documents, and academic contexts
- Weights: Regular (400), Semibold (600)

**Monospace:** JetBrains Mono
- Use for code samples, data displays, and technical documentation

### Type Scale

| Level | Size | Weight | Line Height | Usage |
|-------|------|--------|-------------|-------|
| H1 | 32px | Semibold | 1.2 | Page titles |
| H2 | 24px | Semibold | 1.3 | Section headers |
| H3 | 20px | Medium | 1.4 | Subsection headers |
| H4 | 16px | Medium | 1.4 | Card titles |
| Body | 14px | Regular | 1.5 | Main content |
| Small | 12px | Regular | 1.4 | Captions, metadata |

---

## Logo Usage

### Primary Logo
The GradeFlow logo combines a stylized "G" with a flowing checkmark, representing both grading and progress. The logo should always appear in GradeFlow Blue (#2563EB) on light backgrounds or white on dark backgrounds.

### Clear Space
Maintain clear space around the logo equal to the height of the "G" on all sides.

### Minimum Size
- Digital: 24px height minimum
- Print: 0.5 inch height minimum

### Don'ts
- Don't rotate or distort the logo
- Don't change the logo colors outside approved variations
- Don't place the logo on busy backgrounds
- Don't add effects (shadows, gradients, outlines)

---

## Voice & Tone

### Voice Characteristics
1. **Clear** - No jargon or unnecessary complexity
2. **Supportive** - Acknowledge challenges, offer solutions
3. **Confident** - Expert without being arrogant
4. **Human** - Warm and conversational, never robotic

### Tone Variations by Context

**Product UI**
- Direct and actionable
- Use active voice
- Lead with the action ("Save rubric" not "Rubric will be saved")
- Example: "3 essays need grading before Friday"

**Error Messages**
- Acknowledge the problem
- Explain what happened
- Provide a path forward
- Example: "We couldn't save your changes. Your internet connection may have dropped. Your work is saved locally—try again when you're back online."

**Marketing**
- Aspirational but grounded
- Focus on outcomes, not features
- Use professor/TA testimonials when possible
- Example: "Professor Martinez cut her grading time in half. Here's how."

**Support**
- Patient and thorough
- Assume good faith
- Validate frustration before solving
- Example: "I understand how frustrating it must be to lose work. Let me help you recover it."

---

## Photography & Imagery

### Photo Style
- Natural lighting, no harsh studio setups
- Real academic environments (classrooms, offices, libraries)
- Diverse representation of faculty and students
- Candid moments of teaching and learning
- Devices shown in context, not as hero shots

### Illustration Style
- Simple, geometric shapes
- Limited color palette (max 3-4 colors per illustration)
- Friendly and approachable, not corporate
- Use to explain complex concepts, not for decoration

### Icons
- Use Heroicons (outline style) for consistency
- 24px default size
- 1.5px stroke weight
- Match icon color to surrounding text

---

## Writing Guidelines

### Headlines
- Lead with benefit, not feature
- Use sentence case
- Keep under 8 words when possible
- Good: "Spend less time grading, more time teaching"
- Bad: "GradeFlow's Advanced Grading System Features"

### Body Copy
- Use second person ("you") to speak directly to reader
- Keep paragraphs short (3-4 sentences max)
- Use bullet points for lists of 3+ items
- Avoid passive voice

### CTAs
- Start with action verb
- Be specific about what happens next
- Good: "Start grading" / "Create rubric" / "Invite TAs"
- Bad: "Submit" / "Click here" / "Learn more"

### Academic Sensitivity
- Never trivialize teaching challenges
- Acknowledge that grading is intellectually demanding work
- Respect privacy—never share student or TA information
- Be aware of the stakes—grades affect real lives

---

## Component Patterns

### Buttons
- Primary: GradeFlow Blue background, white text
- Secondary: White background, GradeFlow Blue border and text
- Destructive: Error Red background, white text
- Border radius: 6px
- Padding: 10px 16px
- Min-width: 80px

### Cards
- White background
- 1px border in Medium Gray
- Border radius: 8px
- Shadow: 0 1px 3px rgba(0,0,0,0.1)
- Padding: 16px

### Forms
- Labels above inputs
- Required fields marked with asterisk
- Help text below inputs in Small size, Medium Gray
- Error states: Error Red border, error message below
- Focus state: 2px GradeFlow Blue outline

### Tables
- Header row: Soft Gray background
- Alternating row colors for long lists
- Left-align text, right-align numbers
- Sortable columns indicated with arrow icon

---

## Accessibility

### Color Contrast
- All text must meet WCAG 2.1 AA standards
- Body text: minimum 4.5:1 contrast ratio
- Large text (18px+): minimum 3:1 contrast ratio
- Never use color alone to convey meaning

### Interactive Elements
- All interactive elements must be keyboard accessible
- Focus states must be clearly visible
- Touch targets: minimum 44px × 44px
- Provide text alternatives for icons

### Screen Readers
- All images need descriptive alt text
- Use semantic HTML elements
- Maintain logical heading hierarchy
- Announce dynamic content changes

---

## Usage Examples

### Correct Usage
✓ "GradeFlow helps professors manage their TAs more effectively."
✓ "Sign up for a free trial" (specific CTA)
✓ Using GradeFlow Blue for primary actions
✓ Real photos of diverse educators

### Incorrect Usage
✗ "GradeFlow is a synergistic solution for educational paradigm shifts." (jargon)
✗ "Click here" (vague CTA)
✗ Using logo colors for non-brand elements
✗ Stock photos of people in suits pointing at screens

---

## Contact

For brand questions or asset requests:
- Email: brand@facultyproducts.com
- Slack: #brand-guidelines (internal)
- Asset library: brand.facultyproducts.com (login required)

*These guidelines are living documentation and will evolve with our brand. Last major update: November 2025.*
